/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.content.entityTicker;

import com.hoshino.cti.content.entityTicker.EntityTicker;
import com.hoshino.cti.content.entityTicker.EntityTickerInstance;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTickerManager {
    public static final ConcurrentHashMap<Entity, ConcurrentHashMap<EntityTicker, EntityTickerInstance>> TICKER_MAP = new ConcurrentHashMap();

    public static EntityTickerManagerInstance getInstance(Entity entity) {
        return new EntityTickerManagerInstance(entity);
    }

    public static boolean tick(Entity entity) {
        if (entity.getPersistentData().m_128441_("cti_tickers")) {
            EntityTickerManager.load(entity);
        }
        if (!TICKER_MAP.containsKey(entity)) {
            return true;
        }
        if (TICKER_MAP.get(entity) == null || TICKER_MAP.get(entity).isEmpty()) {
            TICKER_MAP.remove(entity);
            return true;
        }
        boolean doTick = true;
        EntityTickerManagerInstance managerInstance = new EntityTickerManagerInstance(entity);
        if (managerInstance.instanceMap == null) {
            return true;
        }
        List<EntityTickerInstance> instancesCopy = List.copyOf(managerInstance.instanceMap.values());
        for (EntityTickerInstance instance : instancesCopy) {
            EntityTicker ticker = instance.ticker;
            if (!ticker.isInfinite()) {
                --instance.duration;
            }
            boolean bl = doTick = doTick && ticker.tick(instance.duration, instance.level, entity);
            if (instance.duration > 0) {
                managerInstance.setTicker(instance);
                continue;
            }
            managerInstance.removeTicker(ticker);
        }
        if (entity instanceof Player) {
            return true;
        }
        return doTick;
    }

    public static void saveAll() {
        ((ConcurrentHashMap.KeySetView)TICKER_MAP.keySet()).forEach(EntityTickerManager::save);
    }

    public static void load(Entity entity) {
        CompoundTag nbt = entity.getPersistentData().m_128469_("cti_tickers");
        ConcurrentHashMap instances = new ConcurrentHashMap();
        if (!nbt.m_128456_()) {
            nbt.m_128431_().forEach(string -> {
                EntityTickerInstance instance;
                if (nbt.m_128425_(string, 10) && (instance = EntityTickerInstance.readFromNbt(nbt.m_128469_(string), new ResourceLocation(string))) != null) {
                    instances.put(instance.ticker, instance);
                }
            });
        }
        TICKER_MAP.put(entity, instances);
        entity.getPersistentData().m_128473_("cti_tickers");
    }

    public static void save(Entity entity) {
        if (entity == null) {
            return;
        }
        CompoundTag nbt = new CompoundTag();
        if (TICKER_MAP.get(entity) != null) {
            TICKER_MAP.get(entity).values().forEach(instance -> instance.writeToNbt(nbt));
            entity.getPersistentData().m_128365_("cti_tickers", (Tag)nbt);
        }
    }

    public static class EntityTickerManagerInstance {
        @Nullable
        protected ConcurrentHashMap<EntityTicker, EntityTickerInstance> instanceMap;
        public final Entity entity;

        public EntityTickerManagerInstance(Entity entity) {
            this.entity = entity;
            this.instanceMap = TICKER_MAP.get(entity);
        }

        public boolean hasTicker(EntityTicker ticker) {
            if (this.instanceMap == null) {
                return false;
            }
            return this.instanceMap.containsKey(ticker);
        }

        @NotNull
        public Optional<EntityTickerInstance> getOptional(EntityTicker type) {
            return Optional.ofNullable(this.getTicker(type));
        }

        @Nullable
        public EntityTickerInstance getTicker(EntityTicker type) {
            if (this.instanceMap == null) {
                return null;
            }
            return this.instanceMap.get(type);
        }

        public void setTicker(EntityTickerInstance instance) {
            if (!this.hasTicker(instance.ticker)) {
                instance.ticker.onTickerStart(instance.duration, instance.level, this.entity);
            }
            if (this.instanceMap == null) {
                this.instanceMap = new ConcurrentHashMap();
                this.instanceMap.put(instance.ticker, instance);
                TICKER_MAP.put(this.entity, this.instanceMap);
            } else {
                this.instanceMap.put(instance.ticker, instance);
            }
        }

        public void addTicker(EntityTickerInstance instance, BiFunction<Integer, Integer, Integer> levelFunction, BiFunction<Integer, Integer, Integer> timeFunction) {
            if (this.instanceMap == null) {
                this.instanceMap = new ConcurrentHashMap();
                TICKER_MAP.put(this.entity, this.instanceMap);
            }
            EntityTickerInstance existing = this.instanceMap.get(instance.ticker);
            int existingLevel = 0;
            int existingTime = 0;
            if (existing != null) {
                existingLevel = existing.level;
                existingTime = existing.duration;
            }
            EntityTickerInstance merged = new EntityTickerInstance(instance.ticker, levelFunction.apply(existingLevel, instance.level), timeFunction.apply(existingTime, instance.duration));
            this.setTicker(merged);
        }

        public void addTickerSimple(EntityTickerInstance instance) {
            this.addTicker(instance, Integer::max, Integer::max);
        }

        public void removeTicker(EntityTicker ticker) {
            if (this.instanceMap != null && this.hasTicker(ticker)) {
                ticker.onTickerEnd(this.instanceMap.get((Object)ticker).level, this.entity);
                this.instanceMap.remove(ticker);
            }
        }
    }
}

